<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Services;

use Gls\GlsPoland\AdePlus\Common\Services;

interface ClientInterface
{
    public function getMaxParcelWeights(): MaxParcelWeights;

    public function getMaxCashOnDeliveryAmount(): float;

    public function getAllowedServices(): Services;

    public function getGuaranteedServices(string $zipCode): Services;

    /**
     * @return string[] country ISO codes
     */
    public function getShopDeliveryAvailableCountries(): array;
}
