<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Configuration\Adapter;

use Gls\GlsPoland\Configuration\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    private $shopId;
    private $shopGroupId;

    public function __construct(bool $isGlobal = false)
    {
        $this->shopId = $this->shopGroupId = $isGlobal ? 0 : null;
    }

    public function get(string $key)
    {
        $value = \Configuration::get($key, null, $this->shopGroupId, $this->shopId, null);

        return '' === $value ? null : $value;
    }

    public function set(string $key, $value): void
    {
        if (\Configuration::updateValue($key, $value, false, $this->shopGroupId, $this->shopId)) {
            return;
        }

        throw new \RuntimeException(sprintf('Could not update the configuration value for key "%s".', $key));
    }

    public function delete(string $key): void
    {
        if (\Configuration::deleteByName($key)) {
            return;
        }

        throw new \RuntimeException(sprintf('Could not remove configuration values for key "%s".', $key));
    }
}
