<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Common\Persistence\ManagerRegistry as LegacyManagerRegistry;
use Doctrine\Persistence\ManagerRegistry;

if (interface_exists(LegacyManagerRegistry::class)) {
    abstract class EntityRepository extends ServiceEntityRepository
    {
        public function __construct(LegacyManagerRegistry $registry)
        {
            parent::__construct($registry, static::getEntityClass());
        }

        abstract protected static function getEntityClass(): string;
    }
} else {
    abstract class EntityRepository extends ServiceEntityRepository
    {
        public function __construct(ManagerRegistry $registry)
        {
            parent::__construct($registry, static::getEntityClass());
        }

        abstract protected static function getEntityClass(): string;
    }
}
